using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.OleDb;
using ADODB;
using System.Data.SqlClient;
using System.Reflection;


namespace Import_ADOc_Recordset__OleDB_
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
        private Connection cn;
        private Command cmd;
        private ADODB.Recordset ADOcRs;
        private DataSet ds; 
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.TextBox txtYearLow;
        internal System.Windows.Forms.Button bntMakeRecordset;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.Button btnImportRS;
        internal System.Windows.Forms.TextBox txtYearHigh;
        internal System.Windows.Forms.Label Label2;
        private System.Windows.Forms.Button bntMake_FO_RO_Recordset;
        private System.Windows.Forms.Button btnClear;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                // Note: this is probably not a good idea to hold open a connection at instance level
                // it's not very scalable and hogs reources...
                cn = new Connection();
                cn.Open("provider=sqloledb;data source=.;initial catalog=biblio;", "Admin", "pw",-1);
                cn.CursorLocation = ADODB.CursorLocationEnum.adUseClient;
                cmd = new Command();
    
                cmd.CommandText = "AU42";
                cmd.CommandType = CommandTypeEnum.adCmdStoredProc;
                cmd.Name = "AuthorsByYearBorn";
                cmd.Parameters.Append(cmd.CreateParameter("@YearLow", ADODB.DataTypeEnum.adInteger, ADODB.ParameterDirectionEnum.adParamInput, 0 , 1947));
                cmd.Parameters.Append(cmd.CreateParameter("@YearHigh", ADODB.DataTypeEnum.adInteger, ADODB.ParameterDirectionEnum.adParamInput, 0 , 1948));
                cmd.ActiveConnection = cn;

                ADOcRs = new Recordset();
                ds = new DataSet();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }


		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.Label1 = new System.Windows.Forms.Label();
            this.txtYearLow = new System.Windows.Forms.TextBox();
            this.bntMakeRecordset = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.btnImportRS = new System.Windows.Forms.Button();
            this.txtYearHigh = new System.Windows.Forms.TextBox();
            this.Label2 = new System.Windows.Forms.Label();
            this.bntMake_FO_RO_Recordset = new System.Windows.Forms.Button();
            this.btnClear = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(72, 240);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(56, 16);
            this.Label1.TabIndex = 10;
            this.Label1.Text = "YearLow";
            // 
            // txtYearLow
            // 
            this.txtYearLow.Location = new System.Drawing.Point(160, 232);
            this.txtYearLow.Name = "txtYearLow";
            this.txtYearLow.Size = new System.Drawing.Size(88, 20);
            this.txtYearLow.TabIndex = 7;
            this.txtYearLow.Text = "1941";
            // 
            // bntMakeRecordset
            // 
            this.bntMakeRecordset.Location = new System.Drawing.Point(296, 272);
            this.bntMakeRecordset.Name = "bntMakeRecordset";
            this.bntMakeRecordset.Size = new System.Drawing.Size(120, 40);
            this.bntMakeRecordset.TabIndex = 6;
            this.bntMakeRecordset.Text = "Make Recordset";
            this.bntMakeRecordset.Click += new System.EventHandler(this.bntMakeRecordset_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(544, 208);
            this.DataGrid1.TabIndex = 4;
            // 
            // btnImportRS
            // 
            this.btnImportRS.Location = new System.Drawing.Point(424, 272);
            this.btnImportRS.Name = "btnImportRS";
            this.btnImportRS.Size = new System.Drawing.Size(120, 40);
            this.btnImportRS.TabIndex = 5;
            this.btnImportRS.Text = "Import Recordset";
            this.btnImportRS.Click += new System.EventHandler(this.btnImportRS_Click);
            // 
            // txtYearHigh
            // 
            this.txtYearHigh.Location = new System.Drawing.Point(160, 272);
            this.txtYearHigh.Name = "txtYearHigh";
            this.txtYearHigh.Size = new System.Drawing.Size(88, 20);
            this.txtYearHigh.TabIndex = 8;
            this.txtYearHigh.Text = "1947";
            // 
            // Label2
            // 
            this.Label2.Location = new System.Drawing.Point(72, 280);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(56, 16);
            this.Label2.TabIndex = 9;
            this.Label2.Text = "YearHigh";
            // 
            // bntMake_FO_RO_Recordset
            // 
            this.bntMake_FO_RO_Recordset.Location = new System.Drawing.Point(296, 224);
            this.bntMake_FO_RO_Recordset.Name = "bntMake_FO_RO_Recordset";
            this.bntMake_FO_RO_Recordset.Size = new System.Drawing.Size(120, 40);
            this.bntMake_FO_RO_Recordset.TabIndex = 11;
            this.bntMake_FO_RO_Recordset.Text = "Make FO/RO RecordSet";
            this.bntMake_FO_RO_Recordset.Click += new System.EventHandler(this.bntMake_FO_RO_Recordset_Click);
            // 
            // btnClear
            // 
            this.btnClear.Location = new System.Drawing.Point(424, 224);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(120, 40);
            this.btnClear.TabIndex = 12;
            this.btnClear.Text = "Clear DataGrid";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(544, 325);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.btnClear,
                                                                          this.bntMake_FO_RO_Recordset,
                                                                          this.Label1,
                                                                          this.txtYearLow,
                                                                          this.bntMakeRecordset,
                                                                          this.DataGrid1,
                                                                          this.btnImportRS,
                                                                          this.txtYearHigh,
                                                                          this.Label2});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void bntMakeRecordset_Click(object sender, System.EventArgs e)
        {
            try
            {
                // The Recordset returned by this method of executing a command can be updateable, whereas
                // the alternative method cmd.Execute() returns only a FO/RO Recordset.
             
                // Assign the command Parameter Values
                cmd.Parameters["@YearLow"].Value = txtYearLow.Text;
                cmd.Parameters["@YearHigh"].Value = txtYearHigh.Text;

                if (ADOcRs.State == 1)
                {
                    ADOcRs.Close();
                }
                
                // Make a call to open the recordset
                // Note here the use of System.Reflection.Missing.Value 
                ADOcRs.Open(cmd,System.Reflection.Missing.Value,CursorTypeEnum.adOpenStatic,LockTypeEnum.adLockOptimistic,-1);
                
                // Disconnect our new recordset
                ADOcRs.ActiveConnection = null;
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }

        }

        private void btnImportRS_Click(object sender, System.EventArgs e)
        {
            try
            {
                OleDbDataAdapter da = new OleDbDataAdapter();
                


                // Fill the dataset from the recordset 
                // Notice that I pass in a clone of the recordset since Fill() will close 
                // any recordset passed it it passed
                

                da.Fill(ds, ADOcRs.Clone(LockTypeEnum.adLockUnspecified), "AuthorsByYearBorn");

                // Populate the DataGrid from the DataSet...
                DataGrid1.DataSource = ds.Tables[0];
                
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }


        }

        private void bntMake_FO_RO_Recordset_Click(object sender, System.EventArgs e)
        {
            try
            {
                // The things to notice here are:
                // 1) You need to create an object parameter array to hold the Parameter values
                //    in my testing cmd.Execute did not respect any parameter values that you
                //    may have already set on the command object.
                // 2) The recordset returned by cmd.Execute RO/FO
    
                object RecordsAffected = null;
                object myparamValues = new object[]{txtYearLow.Text, txtYearHigh.Text};
                ADOcRs = cmd.Execute(out RecordsAffected, ref myparamValues ,0);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnClear_Click(object sender, System.EventArgs e)
        {
            DataGrid1.DataSource=null;
        }

	}
}
